(function ($) {
    'use strict';

    function login_dropdown() {
        $('.site-header-account').mouseenter(function () {
            $('.account-dropdown', this).append($('.account-wrap'));
        });
    }

	function account_side() {
		var $account_side = $('body .header-group-action .site-header-account a');
		var $account_active = $('body .header-group-action .site-header-account .account-dropdown');
		$(document).mouseup(function (e) {
			if ($account_side.has(e.target).length == 0 && !$account_active.is(e.target) && $account_active.has(e.target).length == 0) {
				$account_active.removeClass('active');
			}
		});
		$account_side.on('click', function (e) {
			e.preventDefault();
			e.stopPropagation();
			$account_active.toggleClass('active');
		});
	}

    function blog_style() {
		$('.blog .hentry, .archive .hentry').last().css({'border-bottom': 0, 'padding-bottom': 0});
	}

	function cross_sells_carousel() {
		var csell_wrap = $('body.woocommerce-cart .cross-sells ul.products');
		var item = csell_wrap.find('li.product');

		if(item.length > 3) {
			csell_wrap.slick(
				{
					dots: true,
					arrows: false,
					infinite: false,
					speed: 300,
					slidesToShow: parseInt(3),
					autoplay: false,
					slidesToScroll: 1,
					lazyLoad: 'ondemand',
					responsive: [
						{
							breakpoint: 1024,
							settings: {
								slidesToShow: parseInt(3),
							}
						},
						{
							breakpoint: 768,
							settings: {
								slidesToShow: parseInt(2),
							}
						}
					]
				}
			)
		}
	}

    function handleWindow() {
        var body = document.querySelector('body');

        if (window.innerWidth > body.clientWidth + 5) {
            body.classList.add('has-scrollbar');
            body.setAttribute('style', '--scroll-bar: ' + (window.innerWidth - body.clientWidth) + 'px');
        } else {
            body.classList.remove('has-scrollbar');
        }
    }

    function svg_iconbox() {
		var wrapper = $('body .elementor-widget-icon-box.elementor-view-stacked-freshio .elementor-icon');
		var svg_icon = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n' +
			'\t viewBox="0 0 84 82" style="enable-background:new 0 0 84 82;" xml:space="preserve">\n' +
			'<path d="M2.7,57.7c0-0.4-0.2-0.8-0.4-1.2c-0.1-0.2-0.1-0.3-0.2-0.5c0,0,0,0,0,0c0,0,0.1,0,0.1-0.1c0,0,0,0,0-0.1c0,0,0-0.1-0.1-0.1\n' +
			'\tc0,0,0,0-0.1,0c0-0.1,0-0.1-0.1-0.2c0,0,0.1,0,0.1,0c0.1,0.2,0.2,0.4,0.4,0.5c0,0.1,0,0.2,0.1,0.3l0,0l0,0C2.7,56.7,2.8,57,3,57.3\n' +
			'\tc0,0,0,0,0,0c0,0.1,0.1,0.2,0.2,0.4l0,0c0.1,0.3,0.2,0.5,0.4,0.8c0.3,0.1,0.4,0.6,0.5,0.9c0.3,0.6,0.6,1.2,0.9,1.7\n' +
			'\tc0.3,0.6,0.6,1.1,0.9,1.7l0,0c0,0,0,0,0,0c0-0.1,0-0.1,0-0.2c-0.3-0.5-0.6-1-0.8-1.5c-0.4-0.7-0.7-1.4-1-2.1c0,0,0.1,0.1,0.1,0\n' +
			'\tc-0.2-0.6-0.4-1.3-0.8-1.5c0-0.1-0.1-0.1-0.1-0.2c0,0,0,0,0.1,0c0,0,0,0,0-0.1l0,0c0,0,0-0.1-0.1-0.1c0,0-0.1,0-0.1,0\n' +
			'\tc0,0,0,0-0.1-0.1c-0.2-0.2-0.2-0.4-0.2-0.7l0-0.1l0,0c0-0.1,0-0.2,0-0.3c-0.1,0-0.1-0.2-0.2-0.1l0,0c-0.1-0.3-0.2-0.7-0.2-0.9\n' +
			'\tc0.2,0.5,0.5,1,0.7,1.6c0.4,0.8,0.7,1.6,1.1,2.4c0.4,0.8,0.8,1.5,1.2,2c0,0,0,0,0.1,0c0.2,0.4,0.4,0.7,0.5,1.1c0.1,0,0.1,0,0.2,0\n' +
			'\tc-0.2-0.4-0.4-0.7-0.5-1.1c0.2,0.1,0.4,0.2,0.5,0.1c0,0,0-0.1,0.2,0.1c0.1,0.3,0.2,0.6,0.4,1c0,0,0,0.1,0,0.1\n' +
			'\tc0.1,0.2,0.1,0.3,0.2,0.4C7,62.7,7,62.8,7,62.9c0.1,0.1,0.1,0.1,0.2,0.1c0.1,0.1,0.2,0.3,0.3,0.4c0,0,0,0,0,0\n' +
			'\tc0.3,0.4,0.5,0.9,0.7,1.3c0.5,0.8,1.1,1.6,1.7,2.3c0.6,0.7,1.1,1.4,1.4,2c0.1-0.1,0.3,0.1,0.5,0.2c0.9,0.8,1.7,1.7,2.6,2.5\n' +
			'\tc0.9,0.8,1.7,1.5,2.6,2c0.1,0.1,0.1,0.2,0.2,0.3c0.1-0.1,0.1-0.1,0.2-0.2l0.1-0.2l0,0.2c0,0.1,0.1,0.1,0.2,0.2\n' +
			'\tc0.2,0,0.4,0.1,0.4,0.4l0,0l0,0c-0.1,0-0.2,0.1-0.2,0.1c0.3,0.2,0.6,0.4,0.7,0.7c0,0,0,0,0,0c0.1,0,0.1-0.1,0.2-0.1\n' +
			'\tc0-0.3,0-0.5-0.1-0.8l0-0.1l0.1,0c0.5,0.1,1,0.4,1.6,0.9c0,0,0.1,0.1,0.1,0.1l0,0l0,0c0,0.1,0,0.1,0.1,0.2c0.1,0.1,0.2,0.2,0.4,0.3\n' +
			'\tl0,0c0.1,0.1,0.1,0.2,0.2,0.3c0.1,0.1,0.1,0.1,0.2,0.2l0,0l0,0c0,0.1,0,0.1,0.1,0.2c0.2,0.2,0.5,0.3,0.7,0.4\n' +
			'\tc0.4,0.2,0.8,0.3,1.1,0.7l0,0.1l-0.1,0c0,0,0,0,0,0l0,0c0,0,0,0,0,0c0.1-0.1,0.2-0.1,0.3,0c0.1,0,0.2,0.2,0.2,0.3\n' +
			'\tc0.1,0,0.1,0.1,0.2,0.1l0,0l0,0c0.1,0.1,0.2,0.1,0.3,0.2c0,0,0-0.1,0.1-0.2l0.1-0.3l0,0.3c0,0.2,0.1,0.3,0.2,0.4\n' +
			'\tc0.1,0.1,0.2,0.1,0.3,0.2c0,0,0.1,0,0.1,0c0.1,0,0.3,0.1,0.5,0.2l0.1,0l-0.1,0c0,0,0.1,0,0.1,0.1c0.2,0,0.3,0,0.4,0\n' +
			'\tc0.1,0,0.2,0.1,0.2,0.2c0.2,0.1,0.4,0.1,0.6,0.2c-0.1,0.1,0,0.3,0.1,0.2c-0.1-0.1,0-0.1,0.1-0.1l0,0c0,0,0.1,0,0.1,0l0,0l0.1,0\n' +
			'\tl0,0.1c0,0,0,0,0,0l0.2,0.1c0,0,0.1,0,0.1,0l1.4,0.6c0.1-0.2,0.3-0.2,0.4-0.2c0.3,0,0.5,0.3,0.6,0.5l0.1,0L30,80.6c0,0,0,0,0,0\n' +
			'\tl0-0.1l0,0c0.3-0.3,0.6-0.2,0.8,0c0.1,0.1,0.2,0.1,0.2,0.1c0.4,0.1,0.6,0.2,0.8,0.2c0.1,0,0.2,0.1,0.3,0.1c0.4,0.1,0.8,0.2,1.2,0.3\n' +
			'\tl0.1,0c0,0,0,0,0,0l0,0c0.4,0.1,0.9,0.2,1.2,0.3c0,0,0,0,0,0c0-0.1,0.1-0.1,0.1-0.1c0.1,0,0.2,0,0.3-0.1l0,0l0,0\n' +
			'\tc2.1,0.5,4.5,0.7,7,0.6c2.2-0.1,4.6-0.4,7.1-0.9c0.5-0.1,1-0.2,1.5-0.3c0.9-0.2,1.9-0.4,2.8-0.6c1.6-0.4,2.9-0.8,4-1.3\n' +
			'\tc0.2-0.1,0.3-0.2,0.5-0.3c0.2-0.1,0.3-0.2,0.5-0.3c0.4-0.2,0.6-0.3,0.9-0.5l0.1-0.1c0.3-0.2,0.5-0.3,0.8-0.3\n' +
			'\tc0.3-0.1,0.5-0.2,0.8-0.4c0,0,0.1-0.1,0.1-0.2c0-0.1,0.1-0.2,0.2-0.3c0.3-0.2,0.6-0.3,1-0.4c0.1,0,0.2-0.1,0.3-0.1\n' +
			'\tc0.4-0.1,0.8-0.3,1-0.7l-0.1-0.1l0.2,0l0,0c0.2,0.1,0.3,0.1,0.4,0c0.1-0.1,0.2-0.2,0.1-0.4l-0.1-0.1l0.1,0c0.1,0,0.2,0.1,0.3,0.1\n' +
			'\tc0.1,0.1,0.2,0.1,0.3,0.1c0.2-0.5,0.6-0.8,1-1c1.9-1.2,3.6-2.5,5.1-4.1c1.5-1.6,2.8-3.4,3.8-5.3l0-0.1l0.1,0c0.1,0.1,0.2,0,0.2-0.1\n' +
			'\tc0,0,0.1-0.1,0.1-0.1c0,0,0-0.1,0-0.1c0-0.1,0.1-0.1,0.1-0.1c0,0,0.1-0.1,0.1-0.1c0,0,0,0-0.1-0.1l-0.1,0l0-0.1c0.7-0.9,1.3-2,1.9-3\n' +
			'\tc1.1-2,2.1-4.3,3.2-7.3l0,0l0,0c0.1,0,0.2,0,0.2,0c0.1,0,0.1,0,0.1,0c0,0,0,0,0,0c-0.1-0.1-0.2-0.1-0.3-0.1c-0.1,0-0.3,0-0.4,0.1\n' +
			'\tl0,0l0,0c-1.1,3-2.1,5.3-3.2,7.2c-0.6,1.1-1.2,2.1-1.9,3l0,0l0,0c-0.2,0-0.4,0.2-0.6,0.6c-0.1,0.2-0.2,0.3-0.3,0.5\n' +
			'\tc-0.1,0.1-0.1,0.2-0.2,0.3l0,0l-0.1,0c0,0,0,0.1,0,0.1c0,0.1-0.1,0.1-0.1,0.2c0,0-0.1,0.1-0.1,0.1l0,0l0,0l0,0.1l0,0\n' +
			'\tc0,0-0.1-0.1-0.1-0.1c0,0,0,0,0,0l0,0l0,0c0,0.1,0,0.1,0,0.2c-0.1,0.4-0.1,0.8-0.7,0.8c-0.2,0.6-0.5,1.2-1,1.8\n' +
			'\tc-0.5,0.6-1.1,1.1-1.8,1.5c-0.4,0.7-1,1.3-1.9,2c-0.6,0.4-1.1,0.8-1.7,1.2c-0.2,0.2-0.5,0.3-0.7,0.4l-0.1,0l0-0.1\n' +
			'\tc-0.1-0.2-0.1-0.4-0.1-0.6c0-0.2,0.2-0.3,0.3-0.4c0,0,0,0,0.1,0c0.2-0.1,0.3-0.2,0.3-0.4c0,0,0-0.1,0-0.1l0-0.2l0.1,0.1\n' +
			'\tc0,0,0.1,0.1,0.1,0.1c0.1,0,0.3-0.1,0.4-0.3l0,0c0.2-0.2,0.5-0.5,1-0.4c0-0.1,0-0.1,0-0.2c0-0.1,0-0.2,0-0.2l0,0l0,0\n' +
			'\tc0.4,0,0.6-0.3,0.7-0.5c0.1-0.1,0.2-0.3,0.3-0.4c0.2-0.2,0.4-0.3,0.6-0.4c0.1-0.1,0.2-0.2,0.4-0.3c0.4-0.3,0.5-0.5,0.5-0.9l0,0l0,0\n' +
			'\tc0,0,0-0.1,0.1-0.1c0.1-0.1,0.2,0,0.4,0c0.1,0,0.2,0.1,0.3,0c0,0,0-0.1-0.1-0.1c0-0.1-0.1-0.2,0-0.3c0.1-0.2,0.4-0.3,0.6-0.4\n' +
			'\tc0.1,0,0.2-0.1,0.3-0.1c0.2-0.1,0.3-0.2,0.3-0.4c0-0.1,0-0.3-0.1-0.5l0-0.1l0.1,0c0.4,0,0.4-0.2,0.5-0.5l0,0\n' +
			'\tc0.1-0.2,0.2-0.5,0.6-0.5l0,0c0,0,0,0,0,0c0,0-0.1,0-0.1,0l-0.1,0l0.1-0.1c0.1-0.2,0.2-0.3,0.4-0.3l0,0c0,0-0.1,0-0.1,0l-0.1,0\n' +
			'\tl0.1-0.1l0,0c0.1,0,0.2-0.1,0.2-0.2c0-0.1,0-0.2,0-0.3c0-0.2-0.1-0.3-0.1-0.5c0,0,0-0.1,0-0.1c0.1-0.2,0.3-0.4,0.5-0.5\n' +
			'\tc0.1-0.1,0.1-0.1,0.2-0.2c0.3-0.3,0.4-0.5,0.2-0.8l0-0.1l0.1,0c0.7-0.1,0.8-0.5,0.9-0.8c0-0.1,0-0.1,0-0.1c0.1-0.3,0.2-0.3,0.3-0.4\n' +
			'\tc0.1,0,0.1-0.1,0.2-0.2c0-0.1,0.1-0.2,0.1-0.3c0-0.1,0-0.2,0-0.3c0-0.2,0-0.3,0-0.5l0,0l0,0c0.5-0.2,0.7-0.5,0.8-1.1\n' +
			'\tc0-0.1,0-0.1,0-0.2c0-0.1,0-0.3,0-0.4c0-0.2,0-0.4,0-0.6c0-0.2,0.1-0.4,0.2-0.5c0.1-0.1,0.2-0.2,0.3-0.3c0.1-0.1,0.2-0.2,0.3-0.3\n' +
			'\tc0.2-0.3,0.2-0.5-0.1-0.7l-0.1,0l0.1,0c0.2-0.1,0.4-0.3,0.5-0.6l0,0c0.2-0.1,0.3-0.3,0.5-0.4c0.3-0.4,0.4-0.7,0.2-1l0-0.1l0.1,0\n' +
			'\tc0.5-0.2,1-0.5,1.4-0.9l0.3-0.3l-0.2,0.4c0,0.1,0,0.1,0,0.1c0,0.1,0,0.2,0,0.3c0,0.1,0.1,0.1,0.3,0.1c0.1,0,0.1,0,0.1,0c0,0,0,0,0,0\n' +
			'\tc0-0.1,0-0.2,0-0.3l0,0l0.1,0c0.1,0,0.1,0,0.2,0.1c0,0,0,0,0,0c0-0.1-0.1-0.1-0.1-0.2c0,0,0-0.1,0.1-0.1c0.1-0.1,0.2-0.1,0.4-0.1\n' +
			'\tc0.1,0,0.3-0.1,0.4-0.2c0,0,0-0.1,0-0.1c0-0.1-0.1-0.2-0.1-0.3c0,0,0-0.1,0-0.1c0,0,0.1,0,0.2-0.1c0,0,0.2,0,0.2,0\n' +
			'\tc0-0.1-0.1-0.2-0.1-0.3c-0.1-0.1-0.2-0.3-0.2-0.4c0-0.1,0.1-0.1,0.1-0.2l0,0l0,0c0.5-0.1,0.7-0.6,0.8-1.1c0-0.2,0-0.3,0-0.5l0,0l0,0\n' +
			'\tc0.1-0.1,0.1-0.1,0.2-0.2c0,0,0-0.1,0-0.1c0.1-0.1,0.1-0.2,0.2-0.3c0-0.1-0.1-0.2-0.1-0.3l0,0l0,0c0-0.1,0.1-0.2,0.1-0.4l0,0l0,0\n' +
			'\tc0,0,0.1,0,0.1,0c0-0.4-0.1-0.8,0-1.2c0.1-0.1,0.2-0.2,0.3-0.3c0-0.3-0.1-0.3-0.1-0.7c0.1,0,0.1,0.1,0.1,0.1c-0.1-0.8,0.2-0.9,0-1.7\n' +
			'\tc0.1,0,0.1,0.1,0.1,0c-0.1-0.6,0-1.2,0-1.8c0-0.6,0-1.2-0.1-1.8c0.1-0.2,0.2-0.6,0.2-1c0-0.3,0-0.7,0-0.9c0,0,0-0.1-0.1-0.2\n' +
			'\tc0-0.1,0-0.2,0-0.2c0-0.2,0-0.5-0.1-0.8c0-0.2,0-0.3,0-0.5c0-0.1,0.1-0.3,0.1-0.4c0-0.6-0.2-1.3-0.2-1.8c0,0,0,0,0,0\n' +
			'\tc0.2,1.2,0.4,2.3,0.6,3.4l0,0c0,0-0.1,0.1-0.1,0.2c0,0.1,0,0.1,0.1,0.1l0,0l0.1,0l0,0c0,0,0.1-0.1,0.1-0.2c0-0.1,0-0.1-0.1-0.1l0,0\n' +
			'\tc0-0.3,0-0.7,0-1.1c0-0.1-0.1-0.2-0.1-0.3c0-0.1,0-0.2-0.1-0.2c0,0,0,0,0.1,0c0,0,0.1-0.1,0-0.1c-0.1-0.9-0.2-1.8-0.4-2.7\n' +
			'\tc-0.1-1-0.3-1.9-0.6-2.9c0-0.1-0.1-0.1-0.1-0.1c0,0,0,0.1,0,0.1c0.3,0.9,0.4,1.9,0.6,2.8c0.1,0.4,0.1,0.7,0.1,1.1\n' +
			'\tc-0.1-0.1-0.1-0.2-0.1-0.4c-0.1-0.6-0.2-1.3-0.3-1.8c0-0.1,0-0.1-0.1-0.1c0,0,0-0.1,0-0.1c-0.3-1.5-0.7-2.6-1.3-3.9c0,0,0,0,0-0.1\n' +
			'\tc0-0.1-0.1-0.1-0.1-0.2c0,0,0-0.2-0.1-0.3l0,0c0,0,0,0,0,0c0,0-0.1-0.2-0.1-0.3c0,0,0,0,0,0c0.1-0.1-0.2-0.7-0.3-0.6l0,0\n' +
			'\tc0,0,0-0.1,0-0.1c0-0.1,0-0.2-0.1-0.3c0,0,0,0-0.1,0c0,0,0,0,0,0.1c0,0.1,0,0.2,0,0.2c0,0,0,0.1,0,0.1c0,0,0,0,0,0\n' +
			'\tc-0.1-0.3-0.2-0.8-0.3-0.8c0-0.2,0-0.4-0.2-0.6c0,0-0.1-0.1-0.1,0c0,0,0,0.1,0,0.1c0.1,0.1,0.1,0.3,0.1,0.5c-0.1,0-0.1-0.3-0.2-0.4\n' +
			'\tc-0.1,0-0.1,0.2-0.2,0.1c-0.3-0.7-0.6-1.2-0.8-1.8c-0.3-0.5-0.5-1-0.8-1.7c-0.1-0.1-0.2-0.2-0.4-0.4c0.2,0.3,0.4,0.7,0.3,0.9l0,0\n' +
			'\tc0,0.1-0.1,0.1-0.3,0.1c0,0,0,0,0,0l0.1,0.3L78,22.3c-0.1-0.2-0.3-0.3-0.4-0.5c-0.6-0.6-1.1-1.3-1.6-2c0,0-0.1,0-0.2,0c0,0,0,0,0,0\n' +
			'\tl0,0l0-0.1c-0.1-0.1-0.1-0.2-0.2-0.3l0,0c0-0.2-0.1-0.5-0.3-0.5l0,0l0,0c-0.1-0.1-0.1-0.2-0.2-0.3c-1.3-1.8-2.8-3.7-4.7-5.5\n' +
			'\tc-0.4-0.4-0.8-0.8-1.1-1.1c-0.7-0.7-1.3-1.4-2-2c-1.2-1.2-2.3-2.1-3.3-2.7c-0.2-0.1-0.3-0.2-0.5-0.3c-0.2-0.1-0.4-0.2-0.5-0.3\n' +
			'\tc-0.4-0.3-0.6-0.4-0.9-0.5l-0.1,0c-0.3-0.1-0.5-0.3-0.7-0.5c-0.2-0.2-0.4-0.4-0.7-0.5c-0.1,0-0.2,0-0.3,0c-0.1,0-0.2,0-0.3,0\n' +
			'\tc-0.3-0.1-0.6-0.4-0.9-0.6c-0.1-0.1-0.2-0.1-0.3-0.2c-0.4-0.3-0.7-0.5-1.2-0.5l0,0.1l-0.1-0.2l0,0c0-0.2-0.2-0.4-0.3-0.4\n' +
			'\tc-0.1,0-0.2,0-0.3,0.1l-0.1,0.1l-0.1-0.1c0-0.1-0.1-0.2-0.1-0.3c0-0.1,0-0.2-0.1-0.3c-0.2,0-0.4,0-0.6,0l-0.1,0l0-0.1\n' +
			'\tc0,0,0-0.1,0-0.1c0,0,0,0,0,0c0-0.1,0-0.1,0-0.1c0,0,0,0,0,0c-0.2,0-0.4-0.1-0.5-0.3c-0.2-0.1-0.3-0.3-0.6-0.3l-0.1,0l0-0.1\n' +
			'\tc0,0-0.1,0-0.1,0c0,0-0.1,0-0.1,0c-0.1,0.2-0.1,0.2-0.2,0.3l0,0l0,0c-1-0.5-2.1-0.9-3.2-1.2C50.9,1,50.8,1,50.6,1c0,0,0,0,0,0\n' +
			'\tc-0.1,0-0.2-0.1-0.3-0.1c-0.1,0-0.1,0-0.1,0c0,0,0,0,0,0c-0.1,0-0.1,0-0.2,0c0,0-0.1,0-0.1,0c0-0.1,0.1-0.1,0.1-0.1\n' +
			'\tc-0.8,0-0.9-0.3-1.7-0.2c0-0.1,0.1-0.1,0-0.1c-0.6,0-1.2,0-1.8-0.1c-0.6-0.1-1.2-0.1-1.8,0c-0.4-0.3-1.4-0.2-1.9-0.3\n' +
			'\tc0,0.1-1.1,0.1-1.6,0C41,0.1,40.9,0,40.7,0c-0.6-0.1-1.3,0.1-1.8,0.1c-0.4,0-0.8-0.1-1.3,0c-0.2,0-0.5,0.1-0.8,0.2\n' +
			'\tc-0.1,0-0.3-0.1-0.4-0.1c-1,0.2-1.9,0.4-2.8,0.6c-0.7,0.1-1.3,0.3-1.9,0.5c-0.8,0.2-1.5,0.4-2,0.7c-0.4,0-0.9,0.2-1.4,0.5\n' +
			'\tC27.8,2.7,27.3,3,26.7,3c0.1,0,0.2-0.1,0.2-0.1c-0.4,0.1-0.4,0.4-0.7,0.6c-0.4,0.2-0.8,0.4-1.4,0.7c-0.2,0.1-0.3,0.3-0.4,0.4\n' +
			'\tc-1.2,0.5-2.1,1.2-3.4,2c-0.4,0.2-0.9,0.5-1,0.7c-0.2,0.2-0.2,0.3-0.3,0.5c0,0-0.2,0.1-0.3,0.2c-0.1,0.1-0.2,0.2-0.3,0.4\n' +
			'\tc-0.2,0.2-0.5,0.3-0.8,0.5c-0.4,0.4-0.7,0.8-1.2,1.3c-0.1,0.1-0.1,0.1-0.2,0.2c-0.2,0.2-0.5,0.3-0.7,0.5c-0.8,0.7-1.3,1.6-1.9,1.7\n' +
			'\tc0,0.1,0.1,0.1-0.1,0.2c0,0,0,0,0,0c0.1,0,0.1,0.1,0.2,0.2l0.1,0l0,0.1c0,0.2-0.1,0.4-0.3,0.5l0,0l-0.1-0.1l0,0.1L14,13.4\n' +
			'\tc0,0,0-0.1-0.1-0.1l-0.1,0c0,0,0,0,0,0c0,0,0,0.1,0,0.1c0,0.1,0.1,0.2,0,0.2c0,0.1-0.1,0.2-0.2,0.2l0,0l0,0c-0.2,0-0.4-0.1-0.6-0.1\n' +
			'\tl0,0l0,0c0,0,0,0,0,0c-0.2,0.2-0.3,0.3-0.5,0.5c0-0.1,0-0.1,0.1-0.2c-0.3,0.2-0.9,0.6-0.7,0.9c0,0,0,0,0,0c0,0,0,0.1,0,0.1\n' +
			'\tc-0.3,0.1-0.5,0.6-0.7,0.9c-0.4,0.6-1,1.3-1.4,1.9c0,0-0.1,0.1-0.1,0.1c-0.1,0.3-0.3,0.6-0.4,0.9c-0.6,0.4-0.6,1.1-1,1.5\n' +
			'\tc0,0.1,0.1,0.2,0,0.2c-0.1,0-0.2,0.2-0.3,0.4c-0.2,0.7-0.8,1.5-1.4,2.5c0,0.2,0.1,0.3-0.1,0.7c-0.1,0,0.1-0.2-0.1-0.2\n' +
			'\tc-0.3,0.3-0.1,0.6-0.3,1c-0.1-0.1-0.2,0.1-0.3,0.3c-0.1,0.2,0.1,0.1,0,0.3c-0.2,0.3-0.4,0.8-0.5,1.3c-0.2,0.5-0.3,1.1-0.6,1.5\n' +
			'\tc0.1,0,0.2,0,0.1,0.2c-0.1,0.1-0.2,0.2-0.2,0.2c-0.2,0.9-0.5,1.5-0.7,2.4c0,0.6-0.1,1.2-0.2,1.8c-0.1,0.5-0.2,1.1-0.4,1.5\n' +
			'\tc0,0.1,0.1,0.2,0.1,0.3l0,0.1l-0.1,0C3.1,34.8,3,34.9,3,35c0,0.1,0,0.1,0.1,0.1c0-0.1,0.1-0.1,0.2-0.1l0,0l0,0\n' +
			'\tc0.1,0.2,0.2,0.3,0.3,0.5l0,0l0,0c0,0.1-0.1,0.1-0.1,0.2c0.3,0.2,0.3,0.6,0.3,0.9l0,0c0,0.2-0.1,0.3-0.1,0.5c0,0.2-0.1,0.4-0.1,0.5\n' +
			'\tl0,0l0,0c-0.4,0-0.7,0.1-1,0.3l0,0l0,0c0,0,0,0,0,0c0,0,0,0,0,0c0,0,0.1,0,0.1,0l0.1,0l0,0c0.2-0.2,0.5-0.2,0.9-0.3l0,0l0,0\n' +
			'\tc0,0,0.1,0.1,0.3,0l0.3,0L4,37.9c-0.3,0.2-0.4,0.3-0.4,0.4c0,0.1,0,0.2,0,0.3c0,0.1,0,0.2,0,0.3l0,0.1l-0.1,0c-0.1,0-0.2,0-0.4,0\n' +
			'\tl0,0l0,0c0,0-0.1-0.1-0.1-0.1l0,0l0,0c0,0,0,0,0,0l0,0l0,0c0-0.1,0.1-0.1,0.1-0.2c0,0-0.1-0.1-0.1-0.1c-0.1,0-0.2,0-0.2,0.1\n' +
			'\tc0,0,0,0.1-0.1,0.2l0,0l0,0c0,0-0.1,0-0.1,0l0,0l0,0c0,0.1,0,0.3,0,0.4l0,0c0,0,0,0,0,0l0,0.1l0,0c0,0,0,0,0,0c0,0,0.1,0,0.1,0l0,0\n' +
			'\tl0,0c0,0,0,0,0.1,0l0,0l0,0l0,0l0,0c0,0,0,0.1-0.1,0.1c0,0,0,0,0,0c0,0,0,0.1,0.1,0.1c0.1,0,0.2,0,0.3-0.1c0,0,0.1-0.1,0.1-0.1l0,0\n' +
			'\tl0,0c0,0,0.1,0,0.1,0l0,0l0.2,0l0,0c0.2,0.1,0.2,0.2,0.2,0.4c0,0.1-0.1,0.3-0.2,0.4c0,0.1,0.1,0.1,0.1,0.2c0.1,0.1,0.1,0.2,0.2,0.2\n' +
			'\tl0.1,0l-0.1,0.1c-0.2,0.3-0.3,0.5-0.3,0.9c0,0.3,0,0.5,0,0.8c0,0.1,0,0.2,0,0.3c0,0.4,0.1,0.8,0,1.2c0,0.1,0,0.2-0.1,0.3l0,0l0,0\n' +
			'\tc-0.2,0-0.4,0-0.4,0c-0.1-0.1-0.1-0.2-0.1-0.2c0-0.1,0-0.1,0-0.1c0,0-0.1,0-0.4,0c0,0.4,0.2,0.8,0.1,1c0,0.1-0.1,0.2-0.1,0.3\n' +
			'\tc0,1.4,0.2,2.8,0.5,4c0.2,0.8,0.3,1.6,0.6,2.1c0,0.4,0.2,0.9,0.4,1.4c0.2,0.5,0.4,1.1,0.4,1.7c0-0.1-0.1-0.2-0.1-0.2\n' +
			'\tc0.1,0.4,0.3,0.4,0.5,0.7c0.1,0.2,0.2,0.4,0.3,0.7c-0.2,0.1,0,0.1,0.1,0.3c-0.1,0.1-0.2-0.2-0.3-0.2C4.9,56.6,5,56,5.2,56.4l0,0\n' +
			'\tc0,0,0,0,0,0.1l0.3,0.6c0.1,0.3,0.2,0.5,0.3,0.8l0,0c0,0.5,0.2,0.8,0.5,1.2c-0.3,0,0.2,0.4,0.3,0.8C7,60.5,7,61.2,7.4,61.3l0.2,0.4\n' +
			'\tc0,0,0,0,0,0l0,0c0,0.1-0.1,0.2,0,0.3c0.4,0.5,0.7,1,1,1.6C9,64,9.3,64.6,9.8,65.1c0,0,0,0,0,0l0,0c0,0-0.1-0.1-0.1,0\n' +
			'\tc0,0,0,0.1,0,0.1l0,0c0.1,0.1,0.1,0.2,0.2,0.2c0,0,0.1,0,0.1,0c0,0,0,0,0-0.1c0,0,0,0,0.1,0c0.1,0.5,0.5,0.9,0.9,1.3\n' +
			'\tc0.4,0.4,0.8,0.8,1,1.3l0,0c0,0-0.1,0-0.1,0c0,0,0,0,0,0c0,0-0.1,0-0.1,0c0-0.1,0-0.1-0.1-0.1l0,0c0-0.1,0.1-0.2,0-0.3l0,0\n' +
			'\tc0,0,0,0,0,0c0,0,0,0,0,0c0,0,0,0,0,0c0,0,0,0,0,0c-0.2-0.2-0.3-0.1,0,0.1c0,0,0,0.1,0,0.1c0,0-0.1,0-0.1,0c-0.1-0.4-0.8-0.7-0.7-1\n' +
			'\tc-0.7-0.6-1.4-1.5-2-2.5c-0.2-0.3-0.4-0.6-0.6-0.9c0,0,0,0,0,0c0,0,0-0.1,0-0.1l0,0c0,0-0.1-0.1-0.1-0.1l0,0c0-0.1-0.1-0.1-0.2-0.2\n' +
			'\tc-0.3-0.5-0.5-0.9-0.6-1.3c-0.3,0-0.5-1-0.8-1.4c-0.1-0.3-0.3-0.3-0.4-0.5c-0.1-0.2,0-0.4,0-0.5c-0.4-0.6-0.8-1-1.1-1.7\n' +
			'\tc0,0,0.1,0,0.1,0c0-0.2-0.3-0.8-0.4-1c-0.3-0.8-0.7-1.7-1-2.7c-0.3-1-0.6-2-0.8-2.9c0-0.1-0.1-0.1-0.1-0.1c0-0.1,0-0.2-0.1-0.2\n' +
			'\tc0-0.3-0.2-0.7-0.3-1.2l0,0c0,0,0,0,0,0c0-0.1,0-0.1,0-0.2c0-0.1,0-0.1,0-0.2c-0.1-0.6-0.2-1.2-0.3-1.7c-0.1-0.9-0.1-1.9-0.2-2.9\n' +
			'\tc-0.1-1.3-0.2-2.6-0.1-4c0-0.3-0.1-0.3-0.1-0.6c0.1-1,0.3-2.1,0.1-2.9l0,0c0-0.3,0-0.6,0-0.9l0,0c0.1-0.9,0.2-2.1,0.4-3l0-0.1l0.1,0\n' +
			'\tc0,0,0,0,0,0v0c0,0,0,0,0.1,0c0,0,0,0,0,0l0,0c0,0,0.1,0,0.1,0c0,0,0,0,0,0l0,0l0,0c0-0.2,0-0.5,0-0.7l0-0.4l0.1,0.4c0,0,0,0,0,0\n' +
			'\tc0,0,0,0,0-0.1c0.4-0.9,0.2-1.6,0.5-2.4c-0.2,0-0.1-0.3-0.1-0.5c0.3-0.7,0.2-1.2,0.6-1.8l0.1,0l0,0c0,0.1,0,0.1-0.1,0.2\n' +
			'\tc-0.1,0.1-0.1,0.3-0.1,0.4c0,0.1,0,0.1,0.1,0.1c0,0,0.1-0.1,0.1-0.1c0,0,0,0,0-0.1c0-0.1,0-0.1,0.1-0.3c0-0.1,0.1-0.2,0.1-0.3l0,0\n' +
			'\tc0.1-0.1,0.1-0.4,0.2-0.7c0-0.1,0.1-0.2,0.1-0.3c0-0.1,0.1-0.2,0.1-0.3c0-0.1,0.1-0.2,0.1-0.3l0,0c0.4-1,0.7-1.9,1.1-2.7\n' +
			'\tc0.4-0.9,0.8-1.7,1.3-2.7l0,0c0,0,0-0.1,0.1-0.1C6.9,20.6,7,20.5,7,20.5c0,0,0,0,0,0c0,0,0-0.1,0-0.1c0,0,0,0-0.1,0\n' +
			'\tc-0.1,0.1-0.1,0.1-0.2,0.2c0,0,0,0,0,0c-0.2,0.1-0.3,0.4-0.5,0.3c0.1-0.1,0.2-0.3,0.1-0.4c0-0.1,0.1-0.1,0.1-0.2c0-0.1,0-0.2,0-0.2\n' +
			'\tc0,0-0.1,0-0.1,0.1c-0.1,0.1-0.1,0.2-0.1,0.3l0,0c-0.1,0-0.3,0.6-0.4,0.6c-0.2,0-0.1-0.2-0.3-0.3c-0.5,0.7-1,1.6-1.3,2.5\n' +
			'\tc0.1,0.2,0.4-0.3,0.3,0c-0.3,1-0.7,0.8-1,1.4c0.1,0.3,0.4,0,0.6-0.2c-0.1,0.3-0.1,0.4-0.2,0.8c-0.2,0-0.1-0.2-0.3-0.2\n' +
			'\tc-0.1,0.2-0.4,0.6-0.6,1C2.9,26.6,2.8,27,3,27.1c0.2-0.1,0.2-0.8,0.4-0.7c0,0.5-0.4,1-0.7,1c-0.1,0.4-0.1,0.5-0.2,0.9\n' +
			'\tc-0.6,0.8-0.7,1.7-0.9,2.9c-0.1,0.5-0.3,0.9-0.1,1.2c0.3,0,0.3-0.9,0.6-0.9c-0.1,0.7-0.5,1.3-0.8,2c0.2,0.2,0.2-0.3,0.4-0.1\n' +
			'\tc0,0.2,0,0.5,0,0.7c-0.4,0.1-0.8,0.9-0.7,1.6l0,0c0,0.1,0,0.2,0,0.2c0,0.1,0,0.2-0.1,0.3c0,0.1,0,0.2,0,0.2c0,0.1,0.1,0.1,0.1,0\n' +
			'\tc0.1-0.1,0.1-0.3,0.1-0.5c0,0,0-0.1,0-0.1c0.1,0,0.1-0.3,0.2-0.3c0.1,0.3,0.1,0.8,0,1.2c-0.1,0.4-0.2,0.8-0.4,1l0,0l0,0\n' +
			'\tc0,0-0.1,0.1-0.1,0.1c-0.1,0-0.1-0.2-0.2-0.1c-0.2,0.5-0.1,0.8-0.3,1c0-0.3,0.1-0.6,0-0.9c-0.1,0.3-0.2,0.6-0.3,0.8\n' +
			'\tc0,0.1,0,0.1,0,0.2c0.1,0.1,0.2,0.2,0.2,0.4c0,0.1,0,0.1,0,0.2c0,0.2-0.1,0.4-0.2,0.5c0,0,0,0,0,0c0,0,0,0,0.1,0\n' +
			'\tc0.1,0.1,0.1,0.2,0.1,0.2c0,0,0,0.1,0,0.1c0,0.1,0,0.1,0,0.1c0.1,0.6,0.1,1.3,0,1.8c0,0.1,0,0.1,0,0.2l0,0.1l-0.1,0c0,0-0.1,0-0.1,0\n' +
			'\tc0,0.6,0,1.2,0.1,1.9c0,0.7,0.1,1.3,0.1,2c0.1,0.1,0.1,0.2,0.1,0.3c0,0.2,0.1,0.4,0.1,0.5c0,0.2,0,0.4,0.1,0.6\n' +
			'\tc0.1,0.5,0.3,1,0.5,1.5c0.1,0.3,0.2,0.7,0.3,1c0.3,0.8,0.5,1.8,0.5,2.6l0,0c0,0,0,0,0,0l0,0l0,0.1c0.1,0.2,0.2,0.4,0.1,0.5\n' +
			'\tc0,0.1,0,0.1-0.1,0.2c-0.1,0-0.2,0.1-0.3,0.1c0,0,0,0.1,0,0.1l0,0l0,0.1c0.1,0.2,0.1,0.3,0.1,0.5c0,0.3,0.1,0.5,0.2,0.8\n' +
			'\tc0,0.1,0.1,0.3,0.1,0.4c0,0,0,0,0,0.1c0.1,0.2,0.1,0.4,0.2,0.6c0.1,0.4,0.3,0.7,0.3,1.1c0,0,0,0,0,0C2.6,57.6,2.7,57.6,2.7,57.7z\n' +
			'\t M58.3,77.5L58.3,77.5L58.3,77.5c-0.1-0.2-0.1-0.3-0.1-0.4c0-0.1,0-0.2,0.1-0.2l0,0l0.1,0l0,0.1c0,0.1,0.1,0.2,0.1,0.3l0,0.1\n' +
			'\tc0,0,0,0,0,0.1C58.5,77.4,58.4,77.4,58.3,77.5z M58.9,77.2L58.9,77.2l-0.2,0.2l-0.1,0l0,0c0,0,0,0,0,0l0-0.1c0-0.1-0.1-0.1-0.1-0.2\n' +
			'\tl0,0l0,0c0,0,0-0.1,0.1-0.1C58.6,76.7,58.7,76.8,58.9,77.2z M50.7,1.7c0.4,0.1,0.9,0.2,1.4,0.4l0,0l0.4,0.2l-0.5-0.1\n' +
			'\tc-0.2,0-0.4-0.1-0.6-0.1c-0.4-0.1-0.6-0.2-0.9-0.4l-0.2-0.2L50.7,1.7z M46.2,0.7c0.2,0,0.4,0,0.7,0.1l0.3,0.1l-0.3,0.1\n' +
			'\tc-0.1,0-0.3,0.1-0.4,0.1l0,0.1l-0.1,0c0,0-0.1,0-0.1,0l-0.1,0l0,0C46.2,0.9,46.2,0.8,46.2,0.7l-0.1,0L46.2,0.7z M43.2,0.4L43.2,0.4\n' +
			'\tL43.2,0.4c0,0.1,0,0.2-0.1,0.2l0,0l0,0c0,0,0,0,0,0c0,0,0,0,0,0l0,0V0.5c0,0,0,0,0,0l0,0.1l-0.1,0c-0.2,0-0.5,0.1-0.7,0.2\n' +
			'\tc-0.1,0-0.1,0-0.2,0.1c-0.2,0.1-0.4,0.1-0.5,0c-0.1-0.1-0.2-0.2-0.3-0.4l0-0.1l0.1,0.1c0.2,0.1,0.4,0.1,0.6,0l0,0l0,0\n' +
			'\tc0.2,0,0.4,0,0.6,0c0.2,0,0.3,0,0.4,0l0,0l0,0.1C43,0.4,43.1,0.4,43.2,0.4z M39.8,0.8L39.8,0.8L39.8,0.8c0-0.1,0-0.1,0-0.2\n' +
			'\tc0-0.1,0.1-0.2,0.2-0.2c0.1,0,0.1-0.1,0.1-0.1c0,0,0-0.1,0-0.2l0-0.1l0.1,0c0,0,0,0,0.1,0l0.2,0c0.3,0.1,0.5,0.3,0.6,0.8l0,0l0,0\n' +
			'\tC40.7,1.2,40.1,1,39.8,0.8z M36.5,1.1C36.2,1,36,1,35.7,1l-0.1,0l0-0.1c0-0.1,0-0.1,0-0.2l0,0l0.1-0.1c0,0,0,0,0,0l0,0l0,0\n' +
			'\tc0.1,0.1,0.4,0.2,0.7,0.3l0,0l0,0C36.6,1,36.6,1,36.5,1.1L36.5,1.1L36.5,1.1z M57.4,4.6c-0.2-0.1-0.4-0.2-0.6-0.3l-0.1-0.1l0.2,0\n' +
			'\tc0.1,0,0.1,0,0.2,0l0,0l0.1,0.1c0,0,0,0,0,0c0,0,0,0,0.1,0l0,0l0,0.1C57.3,4.4,57.4,4.5,57.4,4.6l0.2,0L57.4,4.6z M45.9,4.6L46,4.6\n' +
			'\tc0.1,0.1,0.2,0.1,0.3,0.1l0,0l0,0c0,0.1-0.1,0.2-0.1,0.2c-0.1,0-0.1-0.1-0.2-0.2c0,0,0,0,0,0c0,0,0,0,0,0l0,0.1L46,5\n' +
			'\tc-0.1,0-0.1-0.1-0.1-0.1l0,0.1l-0.1-0.2c0-0.1,0-0.1,0-0.1l0-0.1L45.9,4.6L45.9,4.6z M41.7,4.1c0.1,0,0.1,0,0.2,0.1l0.1,0l0,0.1\n' +
			'\tc0,0-0.1,0.1-0.2,0.1C41.6,4.4,41.6,4.2,41.7,4.1L41.7,4.1L41.7,4.1z M44.2,4.4l0.1,0.1c0,0,0.1,0.1,0.2,0.1l0.1,0.1l-0.1,0\n' +
			'\tc0,0-0.1,0-0.1,0c-0.1,0-0.1-0.1-0.1-0.2L44.2,4.4z M45,4.4l0,0.3l-0.3,0l0.1-0.1C44.8,4.5,44.9,4.4,45,4.4L45,4.4z M40.5,4.3\n' +
			'\tL40.5,4.3L40.5,4.3c0.1-0.2,0.2-0.3,0.3-0.4l0,0l0,0c0,0,0.1,0.1,0.1,0.2l0,0c0,0.1-0.1,0.2-0.2,0.2c-0.1,0-0.1,0-0.1,0.1\n' +
			'\tc0,0,0,0,0,0l0,0.1l-0.1-0.1C40.5,4.4,40.5,4.4,40.5,4.3z M36.2,4.3L36.2,4.3L36.2,4.3c0.1-0.1,0.2-0.2,0.3-0.3l0,0l0,0\n' +
			'\tc0,0,0.1,0,0.1,0l0.1,0l0,0c0,0.1,0,0.2-0.1,0.3C36.5,4.4,36.3,4.3,36.2,4.3z M61.4,7.6C61.4,7.6,61.4,7.6,61.4,7.6\n' +
			'\tc0-0.2,0.1-0.3,0.2-0.5l0,0l0.2,0.2l0,0.1l0,0c0,0,0,0,0,0l-0.1,0.1c0,0.1-0.1,0.1-0.1,0.2l0,0l0,0C61.6,7.6,61.5,7.6,61.4,7.6z\n' +
			'\t M61.5,7.7L61.5,7.7c0.1-0.1,0.2-0.2,0.2-0.3l0.1-0.1c0.1-0.1,0.3,0,0.3,0.1l0,0l0,0c-0.2,0.2-0.4,0.2-0.5,0.2l0,0L61.5,7.7z\n' +
			'\t M33.9,4.8L33.9,4.8L33.9,4.8C34,4.7,34,4.6,34,4.6l0,0l0,0c0.2,0,0.3,0,0.5,0c0.1,0,0.2,0,0.3-0.1l0,0l0,0c0,0.1,0.1,0.2,0.1,0.3\n' +
			'\tl0,0.1l-0.1,0c0,0,0,0,0,0l-0.1,0c-0.1,0-0.3,0-0.4,0.1C34.3,5,34.1,5,33.9,4.8z M27.2,6.1L27.2,6.1c0.1,0,0.1-0.1,0.1-0.2\n' +
			'\tc0-0.1,0-0.2,0.1-0.2l0,0l0,0c0.1,0,0.1,0,0.2,0.1l0.1,0l0,0L28,5.7c0.1,0,0.2-0.1,0.3-0.2l0,0c0.1,0,0.2-0.1,0.3-0.1l0.1,0l0,0.1\n' +
			'\tc0,0,0,0.1,0,0.1c0,0.2,0,0.3,0.3,0.4l0.1,0L29,6c-0.2,0.5-1.2,0.6-1.8,0.5l0,0l0,0v0C27.2,6.3,27.2,6.2,27.2,6.1L27.2,6.1z\n' +
			'\t M26.6,6.5c0-0.1,0.1-0.2,0.2-0.2c0,0,0,0,0.1,0l0.1,0l0,0.1c0.1,0.3,0,0.4-0.2,0.5l0,0l0,0C26.6,6.7,26.6,6.6,26.6,6.5z M22.5,7.9\n' +
			'\tL22.5,7.9L22.5,7.9c0.2-0.2,0.4-0.3,0.7-0.4c0.3-0.1,0.7-0.3,0.9-0.5l0,0l0,0c0.1-0.1,0.1-0.1,0.2-0.1l0,0l0,0\n' +
			'\tc0.2,0.1,0.5,0.1,0.7,0c0.2-0.1,0.5-0.2,0.7-0.1l0.1,0l-0.1,0.1c-0.2,0.3-0.6,0.5-1,0.7c-0.3,0.1-0.7,0.2-1,0.1\n' +
			'\tc-0.1,0.3-0.3,0.6-0.6,0.6C22.9,8.3,22.7,8.2,22.5,7.9z M14.7,13.3c0,0,0-0.1,0-0.1l0-0.1l0,0c0.1-0.2,0.2-0.3,0.3-0.4\n' +
			'\tc0.1-0.1,0.2-0.2,0.3-0.4c0-0.1,0-0.1,0-0.2l0,0l0,0c0,0,0.1,0,0.1,0c0.1,0,0.1,0,0.2,0c0,0,0,0,0,0l0-0.1l0.1,0.1\n' +
			'\tc0.1,0.1,0.3,0.1,0.4,0c0,0,0.1-0.1,0.1-0.1c0-0.1,0-0.1-0.1-0.2l0,0l0,0c0.1-0.1,0.2-0.1,0.3-0.2l0.1-0.1l0,0\n' +
			'\tc0.1-0.1,0.2-0.2,0.3-0.3l0,0c0.5-0.2,0.9-0.4,1.2-0.7l0,0l0,0c0.1,0.1,0.1,0.2,0.1,0.3c0,0.2-0.2,0.2-0.4,0.2c-0.1,0-0.2,0-0.2,0\n' +
			'\tl0,0l0,0c0,0-0.1,0-0.1,0c0,0.1,0,0.1,0,0.2c0,0.1,0,0.2,0,0.3l0,0l0,0c0,0,0,0.1-0.1,0.1c-0.4,0.3-0.8,0.6-1.3,1l0,0l0,0\n' +
			'\tc-0.4,0.3-0.9,0.5-1.2,0.8l-0.1,0l0,0l0,0l-0.2,0.1L14.7,13.3z M80.2,29.5c-0.5-0.1-0.5-0.4-0.5-0.7c0-0.1,0-0.2,0-0.3\n' +
			'\tc-0.1-0.3-0.2-0.6-0.2-0.8c0-0.1,0-0.2-0.1-0.3c-0.2-0.4-0.3-0.8-0.4-1.2c-0.2-0.5-0.3-0.9-0.4-1.2c0,0,0,0,0,0c0,0-0.1,0-0.1-0.1\n' +
			'\tc0-0.1-0.1-0.2-0.3-0.2h0l0,0c-0.4-1.2-1-2.4-1.7-3.7l0.1-0.1c0.3,0.3,0.5,0.6,0.8,0.9c0.2,0.2,0.4,0.4,0.6,0.7\n' +
			'\tc0.4,0.5,0.7,0.9,1,1.2l0,0c0.2,0.4,0.3,0.8,0.3,1.2c0.4,0,0.5,0.2,0.5,0.3l0.1,0.1l0,0l0,0c0,0.1,0.1,0.2,0.1,0.2l0,0l0,0\n' +
			'\tc-0.1,0.1-0.2,0.1-0.2,0.2c0,0,0,0.1,0,0.1c0.2,0,0.2,0,0.2-0.1l0-0.1L80,26c0.1,0.1,0.1,0.1,0.2,0.2l0.1,0l-0.1,0\n' +
			'\tc-0.1,0.1-0.2,0.1-0.3,0.2c0,0-0.1,0-0.1,0.1c0,0,0,0,0,0c0.1,0.1,0.2,0.3,0.2,0.5c0,0.1-0.1,0.1-0.1,0.2c0.1,0,0.3,0.1,0.5,0.1\n' +
			'\tl0.1,0l0,0.1c-0.1,0.1-0.2,0.3-0.2,0.4c0,0.2,0,0.3,0.1,0.5c0,0.1,0.1,0.2,0.2,0.3c0.1,0.2,0.2,0.5,0.3,0.7l0.1,0.1l-0.2,0\n' +
			'\tC80.5,29.5,80.3,29.5,80.2,29.5L80.2,29.5L80.2,29.5z M80.2,30.5c-0.1-0.1-0.1-0.2-0.1-0.4c0-0.1,0.1-0.3,0.2-0.4l-0.1-0.1l0.2,0\n' +
			'\tc0.1,0,0.1,0,0.2,0l0,0l0,0c0,0.2,0,0.3,0,0.3c0,0.2,0,0.3,0.1,0.6l0,0.1l-0.1,0C80.5,30.6,80.3,30.6,80.2,30.5z M80.9,32.3\n' +
			'\tc-0.1-0.1-0.1-0.2-0.1-0.3c0,0,0-0.1,0-0.1c0-0.1,0-0.1,0-0.2l0,0l0,0c0.1,0,0.2,0,0.2,0c0.1,0,0.1,0,0.1,0l0-0.1l0.1,0\n' +
			'\tc0.1,0,0.4,0.3,0.4,0.4c0,0.1-0.1,0.1-0.2,0.2l0,0l-0.2,0C81.1,32.4,81,32.4,80.9,32.3L80.9,32.3L80.9,32.3z M80.7,32.5L80.7,32.5\n' +
			'\tl0-0.1l0.1,0c0.2,0,0.4,0,0.5,0l0.2-0.1l-0.1,0.1c0,0,0.1,0,0.1,0c0,0,0.1,0,0.1,0l0.1,0l0,0.1c0,0.1-0.1,0.2-0.2,0.2\n' +
			'\tC81.3,32.8,80.9,32.7,80.7,32.5z M82.7,40c0,0.1-0.1,0.1-0.1,0.2l-0.1,0.2L82.5,40l0.1,0C82.6,40,82.6,40,82.7,40l0.1-0.1L82.7,40z\n' +
			'\t M81.2,34.2c-0.1-0.1-0.1-0.1-0.2-0.2l0,0l-0.1-0.4l0,0c0-0.1,0.1-0.2,0.2-0.3l0,0l0,0c0.3,0.1,0.4,0.4,0.4,0.6c0,0.1,0,0.2-0.1,0.2\n' +
			'\tl0.1,0.1l-0.1,0c0,0-0.1,0-0.1,0L81.2,34.2L81.2,34.2z M81.9,36.8c0,0-0.1,0-0.1,0l0,0l0,0c-0.1-0.2-0.1-0.5-0.2-0.7l0,0l0,0\n' +
			'\tc0.1,0,0.1,0,0.1-0.1c0,0,0,0,0,0c0,0-0.1,0-0.1,0l-0.1,0.1l-0.4-1.6l0.1,0c0,0,0,0,0.1,0c0.1,0,0.1,0,0.2,0l0.2,0l-0.1,0.1\n' +
			'\tc0,0,0,0,0,0c0,0,0,0,0,0l0,0l0,0c0.1,0,0.2,0,0.2,0.1c0.1,0.1,0,0.3-0.1,0.4c0,0-0.1,0.1-0.2,0.1c0.5,0.6,0.7,1.2,0.6,1.7\n' +
			'\tc0,0.1-0.1,0.3-0.1,0.4l0,0l0,0C82,36.9,81.9,36.8,81.9,36.8z M82.1,37c0,0.1,0.1,0.1,0.1,0.1c0.1,0,0.2,0.1,0.2,0.2l0,0.1l-0.1,0\n' +
			'\tc-0.3,0.1-0.3,0.2-0.3,0.3c0,0.1,0,0.1,0,0.2c0,0.1,0,0.1,0.1,0.2c0.1,0.2,0.1,0.3,0.1,0.5c0,0,0,0.1,0,0.1l-0.1,0.2l0-0.2\n' +
			'\tc-0.1-0.5-0.2-1-0.3-1.5l0-0.1l0.1,0c0,0,0.1,0,0.1-0.1C82,37,82,37,82.1,37l0-0.1L82.1,37z M80.8,48.9c-0.1,0-0.1,0-0.2,0l0,0l0,0\n' +
			'\tc0-0.1-0.1-0.2-0.1-0.3l-0.1-0.1h0c-0.1-0.2-0.1-0.3-0.2-0.4c-0.1-0.4-0.2-0.7-0.1-1.2l0-0.1l0.1,0c0.2,0,0.3,0,0.4,0.1\n' +
			'\tc0,0,0,0,0,0.1c0.1-0.1,0.2-0.3,0.2-0.4c0-0.2,0-0.4,0-0.6c0-0.2-0.1-0.4-0.1-0.7c0,0-0.2-0.1-0.2-0.1c-0.1,0-0.2,0-0.2-0.1l0,0l0,0\n' +
			'\tc0.1-0.3,0.2-0.6,0.3-0.9c0-0.4,0-0.7,0-1c0-0.1,0-0.3,0-0.4c-0.1-0.5-0.1-1.1,0-1.8l0,0l0,0c0,0,0,0,0,0c-0.1-0.1,0-0.2,0-0.3l0,0\n' +
			'\tl0,0c0.1,0,0.1-0.1,0.2-0.1c0.1-0.1,0.2-0.1,0.2-0.2c0,0,0-0.1,0-0.1l0,0l0,0c0,0,0.1,0,0.1-0.1c0,0,0-0.1-0.1-0.1l0,0l0,0\n' +
			'\tc0-0.1,0-0.3,0-0.4c0-0.1,0-0.2,0-0.2c0-0.1,0.1-0.1,0.2-0.1c0.1,0,0.2-0.1,0.2-0.1c0-0.3,0-0.5-0.1-0.8c0-0.3-0.1-0.5,0-0.8\n' +
			'\tc0-0.1,0.1-0.3,0.1-0.4l0.1-0.1l0,0.2c0.2,0.7,0.3,1.3,0.4,1.9l0,0l0,0c0,0,0,0,0,0l0,0l0,0.1c0,0.1,0.1,0.3,0.1,0.4l0,0l0,0\n' +
			'\tc0,0.1,0,0.1,0,0.2c0,0.1,0,0.1,0.1,0.1l0.1,0l0,0.1l0,0c0,0,0,0-0.1,0.1c-0.1,0.1-0.1,0.1-0.2,0.2c0,0,0,0,0,0c0,0,0.1,0,0.1,0\n' +
			'\tc0,0,0-0.1,0.1-0.1l0.1-0.1l0,0.1c0.1,0.6,0.2,1.2,0.3,1.8l0,0l0,0l0,0l0,0c0,0.2,0,0.5,0.1,0.7l0,0.1l-0.1,0c0,0-0.1,0-0.1,0\n' +
			'\tc0,0,0,0,0,0c0,0,0,0,0,0c0,0,0.1,0,0.1,0l0.1,0l0,0.1c0,0.1-0.1,0.1-0.1,0.2c0,0.1,0,0.2,0.1,0.2l0,0l0,0l0,0\n' +
			'\tc-0.1,0.4-0.3,0.8-0.4,1c0,0.1-0.1,0.2-0.1,0.3c-0.1,0.3-0.2,0.6-0.3,1c0,0.2-0.1,0.3-0.1,0.5c-0.1,0.3-0.2,0.8-0.5,1.1l-0.1,0.1\n' +
			'\tl0-0.1c0,0,0-0.1-0.1-0.1c0,0.1-0.1,0.2-0.1,0.2c0,0,0,0,0,0l0,0l0-0.1c0,0-0.1,0-0.1,0l0.1,0.1l0,0l0,0l0.3,0.3l-0.3-0.1\n' +
			'\tc0,0.2,0,0.2,0,0.3c0,0.1,0,0.1,0,0.3l0,0.1l0,0c0.1,0,0.2,0,0.3,0c0,0,0,0,0.1,0l0.1,0l0,0.1C80.9,48.6,80.9,48.7,80.8,48.9\n' +
			'\tL80.8,48.9L80.8,48.9z M3.2,39.1L3.2,39.1c0.1,0,0.2,0,0.3,0l0,0l0,0c0,0,0,0,0,0c0,0,0.1,0.1,0.1,0.1c0,0,0,0.1-0.1,0.1l0.1,0.1\n' +
			'\tl-0.1,0c-0.1,0-0.1,0-0.2,0l0,0L3.2,39.1z M75.5,53.8c0.1,0,0.1,0.1,0.2,0.1c0.1,0,0.1,0.1,0.3,0.1l0,0l0,0c0,0,0,0,0,0\n' +
			'\tc0,0.1-0.1,0.1-0.1,0.1c0,0,0,0,0,0l0.1,0.1l-0.1,0c-0.1,0.1-0.2,0.1-0.3,0c-0.1,0-0.1-0.1-0.1-0.2c0-0.1-0.1-0.2-0.3-0.2l-0.2,0\n' +
			'\tl0.1-0.1c0,0,0,0,0.1,0l0,0l0,0l0,0C75.4,53.9,75.4,53.8,75.5,53.8L75.5,53.8L75.5,53.8z M73.6,54.2c0.2-0.5,0.3-0.9,0.4-1.4l0-0.1\n' +
			'\tl0.1,0c0.2,0,0.2,0,0.3,0l0,0l0,0c0-0.1,0-0.2-0.1-0.3l0,0l0,0c0.1-0.1,0.2-0.3,0.3-0.4c0.5-0.6,1-1.1,1.5-1.5\n' +
			'\tc-0.1-0.1-0.3-0.1-0.2-0.3c0,0,0-0.1,0.1-0.1C76,50,76.1,50,76.2,50l0.1,0l0,0.1c0,0.1,0,0.2,0,0.3c0,0,0,0,0,0l0,0l0,0.2l0,0\n' +
			'\tc0,0,0,0.1,0,0.1c0,0.2-0.1,0.3-0.3,0.4c0.3,0.2,0.3,0.4,0.3,0.5c0,0.1,0,0.1-0.1,0.2c-0.1,0.2-0.4,0.3-0.6,0.4\n' +
			'\tc0.1,0.1,0.1,0.2,0.1,0.3c0,0.2-0.2,0.4-0.4,0.6c-0.1,0.2-0.3,0.3-0.3,0.4c0,0.1,0,0.2,0.2,0.3l0.1,0l-0.1,0c0,0,0,0,0,0\n' +
			'\tc0,0-0.1,0.1-0.1,0.1l0,0l0,0l0,0.1l-0.1,0c0,0-0.2-0.1-0.2-0.2c-0.1,0-0.1,0-0.1,0c0,0,0,0,0,0c0,0.1,0,0.2,0.4,0.6l0,0l0,0\n' +
			'\tc-0.4,0.4-0.7,0.9-0.8,1.4c-0.1,0.2-0.1,0.5-0.2,0.7l0,0l0,0c-0.1,0.1-0.1,0.2-0.2,0.3l0,0l0,0c-0.2,0-0.4,0-0.5,0.1l0,0l0,0\n' +
			'\tC73,57,73,56.9,73,56.8c0,0,0-0.1,0-0.1c0,0,0-0.1,0-0.1c0,0,0-0.1-0.2-0.3l-0.1-0.1l0.2,0c0.2,0,0.3-0.1,0.4-0.2\n' +
			'\tc0.1-0.1,0.2-0.2,0.5-0.1c0,0,0-0.1,0-0.2c0,0-0.2-0.1-0.3-0.2c-0.2-0.1-0.4-0.1-0.4-0.2l0,0l0,0c0.1-0.2,0.2-0.4,0.3-0.5\n' +
			'\tC73.4,54.7,73.5,54.4,73.6,54.2z M3.2,49.1c-0.4-0.6-0.7-1.8-0.6-2.6l0,0l0,0c0.2-0.1,0.4-0.1,0.4-0.2c0.1-0.1,0.2-0.1,0.5-0.1l0,0\n' +
			'\tl0,0c0.1,0.1,0.2,0.2,0.2,0.4c0,0.1-0.1,0.2-0.2,0.3C3.9,47,3.9,47.2,4,47.5c0,0.1,0,0.3,0.1,0.5l0,0.1l-0.6,0.2c0,0,0,0.1,0.1,0.1\n' +
			'\tc0.1,0.1,0.1,0.3,0.1,0.4C3.6,48.9,3.5,49.1,3.2,49.1L3.2,49.1L3.2,49.1z M71.2,62.2C71.2,62.2,71.2,62.2,71.2,62.2L71.2,62.2\n' +
			'\tc0,0.1-0.1,0.1-0.2,0.1c-0.1-0.1-0.1-0.2-0.1-0.2l-0.1,0c0,0,0-0.1,0.1-0.1C71,62,71.1,62.1,71.2,62.2z M71.6,61.1\n' +
			'\tc0.1,0.1,0.2,0.2,0.1,0.3c0,0,0,0.1-0.1,0.1c-0.1,0-0.1,0-0.2,0l0,0c-0.1-0.1-0.1-0.1-0.1-0.2c0,0,0,0,0,0c0,0,0,0,0,0\n' +
			'\tc0,0,0-0.1-0.1-0.1L71.2,61l0.1,0C71.4,61,71.5,61,71.6,61.1z M4.8,54.4c-0.1-0.1-0.1-0.2-0.1-0.3l0,0c0-0.1,0.1-0.2,0.1-0.4\n' +
			'\tc0-0.1,0-0.2,0.1-0.2c0,0,0,0,0,0c0,0,0,0,0,0c-0.1,0-0.1,0.1-0.1,0.2c0,0,0,0,0,0l0,0.1c-0.5-0.1-0.6-0.5-0.7-0.8\n' +
			'\tc0-0.1,0-0.2,0-0.3c0-0.3-0.1-0.6-0.2-0.9l0,0l0,0c0.3-0.2,0.5-0.5,0.5-0.7l0-0.1l0.1,0c0.3,0,0.4,0.2,0.5,0.5\n' +
			'\tc0,0.1,0.1,0.3,0.2,0.3l0.1,0.1l-0.2,0c-0.1,0-0.2,0-0.2,0.1c0,0,0,0.1,0,0.1c0,0.1,0,0.1,0,0.2c0,0.1-0.1,0.1-0.2,0.2l0,0.1\n' +
			'\tc0.4-0.1,0.5,0.2,0.6,0.5c0,0.1,0,0.1,0.1,0.2c0.1,0.3,0.2,0.7,0.4,1l0,0.1l-0.1,0c-0.2,0.1-0.2,0.1-0.2,0.1c0,0,0,0.1,0,0.1l0,0.1\n' +
			'\tl-0.1,0C5.2,54.5,4.9,54.5,4.8,54.4z M69.5,64.9l-0.4-0.3l0.2-0.3l0.4,0.3L69.5,64.9z M69.8,64.1c0.1,0.1,0.1,0.1,0.1,0.2\n' +
			'\tc0,0.1-0.1,0.1-0.2,0.1c0,0-0.1,0-0.1,0c0,0,0,0,0.1,0.1l0.1,0.1l-0.1,0c-0.1,0-0.2,0-0.2-0.1c-0.1-0.1-0.1-0.1-0.2-0.2l0,0l0,0\n' +
			'\tc0-0.1,0-0.1,0.1-0.1c0.1,0,0.2,0,0.3,0C69.6,64.1,69.7,64.1,69.8,64.1L69.8,64.1L69.8,64.1z M6.3,57.3c-0.3-0.1-0.4-0.4-0.4-0.6\n' +
			'\tc0-0.1,0-0.2,0-0.3c0-0.3-0.1-0.7-0.3-0.9l-0.1-0.1l0.1,0c0.2,0,0.4-0.1,0.4-0.2c0,0,0,0,0,0l0-0.2l0.1,0.1c0,0,0.1,0,0.1,0.1l0,0\n' +
			'\tc0,0,0,0.1,0,0.1l0,0l0,0.1c0,0.1,0.1,0.3,0.1,0.4l0,0c0.1,0.3,0.1,0.5,0.2,0.8l0,0.1l0,0C6.4,56.9,6.3,57,6.3,57\n' +
			'\tC6.3,57.1,6.3,57.1,6.3,57.3l0.2,0L6.3,57.3z M68.2,65.7L68.2,65.7c-0.1-0.1-0.2-0.2-0.2-0.2c0-0.1,0.1-0.1,0.2-0.1c0,0,0,0,0,0\n' +
			'\tc0,0,0,0,0,0l-0.1,0l0,0c0,0,0.1,0,0.2,0l-0.1-0.1l0.2,0.1c0.2,0,0.2,0.1,0.2,0.2c0,0,0,0.1-0.1,0.1C68.6,65.7,68.4,65.7,68.2,65.7\n' +
			'\tL68.2,65.7z M9.8,62.6c-0.1-0.1-0.1-0.2-0.1-0.3c0-0.2,0.2-0.5,0.4-0.6l0.1,0l0,0.1c0.1,0.2,0.2,0.3,0.3,0.4\n' +
			'\tc0.1,0.1,0.2,0.2,0.2,0.3c0,0,0,0.1,0,0.1l0,0l0,0c-0.1,0-0.2-0.1-0.3,0l0,0l0,0l-0.1,0C9.9,62.7,9.8,62.6,9.8,62.6z M9.9,63L9.9,63\n' +
			'\tc0.2-0.2,0.3-0.3,0.3-0.4l0,0l0,0c0,0,0.1,0,0.1,0c0,0,0.1,0,0.1,0l0.1,0l-0.2,0.1l0.1,0.1l0,0c-0.2,0.2-0.3,0.2-0.5,0.3l0,0L9.9,63\n' +
			'\tz M14.1,67.7c-0.1-0.2-0.2-0.4-0.2-0.6c0-0.1,0-0.2-0.1-0.3l0,0l0,0c0,0,0-0.1,0.1-0.1l0,0l0,0c0.1,0,0.1,0,0.2,0l0.1,0l0,0.1\n' +
			'\tc0,0.4,0.2,0.8,0.4,1.2l0,0.1l-0.1,0C14.4,68,14.2,67.9,14.1,67.7z M62.6,74.7c0.1-0.1,0.1-0.1,0.1-0.2c0,0,0-0.1,0-0.1l-0.1-0.1\n' +
			'\tl0.1,0c0.1,0,0.2,0,0.3,0c0.1,0,0.3-0.1,0.4,0c0.1-0.2,0.2-0.4,0.3-0.4c0,0,0.1,0,0.1,0c0.1,0.1,0,0.5-0.2,1.1l0,0l-0.1,0\n' +
			'\tc0,0,0,0,0,0c0,0,0,0,0,0.1l0,0.1h-0.1c-0.1,0-0.4,0.1-0.7,0.2l0,0l0,0c-0.1,0-0.2-0.1-0.2-0.3C62.5,74.9,62.6,74.8,62.6,74.7z"/>\n' +
			'</svg>';

		wrapper.append(svg_icon);
	}

    handleWindow();
	blog_style();
    login_dropdown();

	$(document).ready(function () {
		cross_sells_carousel();
		account_side();
	});

	$(window).on('resize',function () {
		handleWindow();
	});
	$(window).on('elementor/frontend/init',() => {
		svg_iconbox();
	});
})(jQuery);

